#/*******************************************************************
# * This file is part of the Emulex Linux Device Driver for         *
# * Fibre Channel Host Bus Adapters.                                *
# * Copyright (C) 2003-2005 Emulex.  All rights reserved.           *
# * EMULEX and SLI are trademarks of Emulex.                        *
# * www.emulex.com                                                  *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of version 2 of the GNU General       *
# * Public License as published by the Free Software Foundation.    *
# * This program is distributed in the hope that it will be useful. *
# * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
# * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
# * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
# * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
# * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
# * more details, a copy of which can be found in the file COPYING  *
# * included with this package.                                     *
# *******************************************************************/
# This Makefile builds the lpfcdfc module for 2.6 Linux kernels.
######################################################################

# $Id: Makefile-2.6.mk 2757 2005-12-09 18:21:44Z sf_support $

ifeq (,$(KERNELVERSION))
   KERNELVERSION := $(shell uname -r)
endif

ifeq (,$(STANDALONE))
   STANDALONE := 1
endif

ifeq (,$(BASEINCLUDE))
   BASEINCLUDE := /lib/modules/$(KERNELVERSION)/build
endif

ifeq ($(OS),RHEL)
  EXTRA_CFLAGS += -DRHEL_FC
else
ifeq ($(OS),SLES)
  EXTRA_CFLAGS += -DSLES_FC
else
ifneq ($(OS),)
  $(error Error: either "make OS=RHEL" or "make OS=SLES" must be specified !!!)
else
ifneq ($(MAKECMDGOALS),clean)
ifneq ($(MAKECMDGOALS),install)
  $(error Error: either "make OS=RHEL" or "make OS=SLES" must be specified !!!)
endif
endif
endif
endif
  export EXTRA_CFLAGS
endif

ifeq ($(shell uname -m),ppc64)
ifndef ($(CROSS_COMPILE))
CROSS_COMPILE := $(shell if [ -e /usr/local/ppc64-current3.0/bin/powerpc64-linux-gcc ]; then \
    echo /usr/local/ppc64-current3.0/bin/powerpc64-linux-; \
    else if [ -e /opt/cross/bin/powerpc64-linux-gcc ]; then \
    echo /opt/cross/bin/powerpc64-linux- ; fi fi)
endif
endif

obj-$(CONFIG_SCSI_LPFC_IOCTLS) := lpfcdfc.o

lpfcdfc-objs := lpfc_cdev.o \
		lpfc_util_ioctl.o \
		lpfc_hbaapi_ioctl.o \
		lpfc_debug_ioctl.o \
		lpfc_misc.o \
		lpfc_hbadisc.o \
		lpfc_els.o \
		lpfc_ct.o \
		lpfc_mbox.o \
		lpfc_mem.o \
		lpfc_nportdisc.o \
		lpfc_sli.o \
		lpfc_scsiport.o \
		lpfc_init.o

ifeq (,$(STANDALONE))
ifeq (,$(INC_TOP))
  EXTRA_CFLAGS += -I$(SUBDIRS)/..
else
  EXTRA_CFLAGS += -I$(INC_TOP)/
endif
endif

ifeq (,$(STANDALONE))
ifneq (,$(INC_TOP))
  DEFINE_EXTERN_SRC := 1
  SOURCEPATH := $(INC_TOP)
else
  DEFINE_EXTERN_SRC := 1
  SOURCEPATH := ..
endif
else
  SOURCEPATH := .
endif

ifneq (,$(DEFINE_EXTERN_SRC))
  EXTERN_SRC := lpfc_hbadisc.c \
		lpfc_els.c \
		lpfc_ct.c \
		lpfc_mbox.c \
		lpfc_mem.c \
		lpfc_nportdisc.c \
		lpfc_sli.c \
		lpfc_scsiport.c \
		lpfc_init.c
endif

clean-files := *.o *.ko *.mod.o *.mod.c .*.cmd .*.flags .tmp_versions $(EXTERN_SRC)

%.c: $(SOURCEPATH)/%.c
	@cp $< ./ || chmod +w $@

build: $(EXTERN_SRC)
	$(MAKE) -C $(BASEINCLUDE) SUBDIRS=`pwd` CONFIG_SCSI_LPFC_IOCTLS=m modules

install:
	install -c lpfcdfc.ko /lib/modules/$(KERNELVERSION)/kernel/drivers/scsi/$(lpioctls-module)
#	install -c $(lpfn-module) /lib/modules/$(KERNELVERSION)/kernel/drivers/net/$(lpfn-module)
	depmod -a

clean:
#	$(MAKE) -C $(BASEINCLUDE) SUBDIRS=$(PWD) CONFIG_SCSI_LPFC=m CONFIG_NET_LPFC=m clean
	@rm -rf $(clean-files)
